#include <algorithm>
#include <iostream>
#include <vector>

struct Offer {
  int idx;
  int weight;
  int value;
  float rating;
} pom;

std::vector<Offer> offers;
bool cmpRating(const Offer &a, const Offer &b) { return a.rating > b.rating; }
bool cmpIndex(const Offer &a, const Offer &b) { return a.idx < b.idx; }
bool cmpValues(const std::tuple<std::vector<Offer>::reverse_iterator,
                                std::vector<Offer>::reverse_iterator, int> &a,
               const std::tuple<std::vector<Offer>::reverse_iterator,
                                std::vector<Offer>::reverse_iterator, int> &b) {
  return std::get<2>(a) > std::get<2>(b);
}

int main() {
  int n, W;
  float epsilon;
  std::cin >> n >> W >> epsilon;

  for (int i = 0; i < n; i++) {
    pom.idx = i + 1;
    std::cin >> pom.weight >> pom.value;
    pom.rating = (float)pom.value / (float)pom.weight;
    offers.push_back(pom);
  }
  std::sort(offers.begin(), offers.end(), cmpRating);

  int count = 0;
  int weight = 0;
  int value = 0;
  auto left = offers.rbegin();
  auto right = offers.rbegin();

  std::vector<std::tuple<std::vector<Offer>::reverse_iterator,
                         std::vector<Offer>::reverse_iterator, int>>
      r;
  while (left != offers.rend()) {
    int nextWeight = left->weight;
    int nextValue = left->value;
    while (weight + nextWeight > W) {
      r.push_back(std::make_tuple(left, right, value));
      weight -= right->weight;
      value -= right->value;
      right++;
      count--;
    }
    weight += nextWeight;
    value += nextValue;
    count++;
    left++;
    r.push_back(std::make_tuple(left, right, value));
  }
  std::sort(r.begin(), r.end(), cmpValues);
  left = std::get<0>(r[0]);
  right = std::get<1>(r[0]);

  std::vector<Offer> rez;
  for (auto it = right; it != left; it++) {
    rez.push_back(*it);
  }
  std::sort(rez.begin(), rez.end(), cmpIndex);

  std::cout << rez.size() << "\n";
  for (auto &offer : rez) {
    // printf("w: %d v: %d r: %.2f%%\n", offer.weight, offer.value,
    // offer.rating),
    std::cout << offer.idx << " ";
  }
  return 0;
}